<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App\Advice;

/**
 * SmartAdvice Api.
 */
abstract class Api {
	/**
	 * Apply advice.
	 *
	 * @param string $advice_id id.
	 *
	 * @return string|bool
	 */
	abstract public function apply( $advice_id );

	/**
	 * Rollback advice.
	 *
	 * @param string  $advice_id id.
	 * @param ?string $reason advice rollback reason.
	 *
	 * @return string|bool
	 */
	abstract public function rollback( $advice_id, $reason );

	/**
	 * Status advice.
	 *
	 * @param string $advice_id id.
	 *
	 * @return string|bool
	 */
	abstract public function status( $advice_id );

	/**
	 * Details advice.
	 *
	 * @param string $advice_id id.
	 *
	 * @return string
	 */
	abstract public function details( $advice_id );

	/**
	 * Subscription.
	 *
	 * @param string $advice_id id.
	 *
	 * @return string
	 */
	abstract public function subscription( $advice_id );

	/**
	 * Agreement.
	 *
	 * @param string $type advice type string, e.g. 'cdn'.
	 *
	 * @return string
	 */
	abstract public function agreement( $type );

	/**
	 * Get options.
	 *
	 * @param string $user system name.
	 *
	 * @return string
	 */
	abstract public function get_options( $user );
}
