<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App;

use CloudLinux\SmartAdvice;

/**
 * Option
 */
abstract class Model {
	/**
	 * Setter.
	 *
	 * @param string $name attribute.
	 * @param mixed  $value attribute.
	 *
	 * @return void
	 */
	public function __set( $name, $value ) {
		if ( property_exists( $this, $name ) ) {
			$this->$name = $value;
		}
	}

	/**
	 * Fill properties.
	 *
	 * @param array $data data.
	 *
	 * @return static
	 */
	public function fill( $data ) {
		if ( ! is_array( $data ) ) {
			$data = array();
		}

		foreach ( $data as $key => $value ) {
			$this->$key = $value;
		}

		return $this;
	}

	/**
	 * Get uid.
	 *
	 * @return string
	 */
	abstract public function uid();

	/**
	 * Is valid model.
	 *
	 * @return bool
	 */
	abstract public function isValid();

	/**
	 * To array.
	 *
	 * @return array
	 */
	abstract public function toArray();
}
