<?php
/**
 * Unsubscription view.
 *
 * @var string $type subscription.
 * @var string $description description.
 * @var string $detailed_description details.
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>
<html>
	<head>
		<title><?php esc_html_e( 'Notifications disabled', 'cl-smart-advice' ); ?></title>
		<style>
			body {
				font-family: "Open Sans", sans-serif;
				font-size: 15px;
				color: #424242;
				line-height: 1.2;
			}
		</style>
	</head>
	<body>
		<div style="border: 1px solid #e0e0e0; margin: 20px auto; padding: 20px; max-width: 640px; border-radius: 7px;">
			<?php
			if ( 'all' === $type ) {
				echo '<p>' . esc_html__( 'You have successfully disabled all advice notifications.', 'cl-smart-advice' ) . '</p>';
			} else {
				echo '<p>' . esc_html__( 'You have successfully disabled notifications related to the following feature.', 'cl-smart-advice' ) . '</p>';
				echo '<h3>' . esc_html( $description ) . '</h3>';
				echo '<p>' . esc_html( $detailed_description ) . '</p>';
			}
			?>
		</div>
	</body>
</html>
