<?php
/**
 * Widget view.
 *
 * @var array $data settings.
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! is_array( $data ) ) {
	$data = array();
}

/**
 * Advices.
 *
 * @var \CloudLinux\SmartAdvice\App\Advice\Model[] $advices
 */
$advices_awp     = isset( $data['advices_awp'] ) ? $data['advices_awp'] : array();
$advices_imunify = isset( $data['advices_imunify'] ) ? $data['advices_imunify'] : array();
$compatible      = isset( $data['compatible'] ) ? $data['compatible'] : false;
?>

<div class="cl-smart-advice" data-smart-advice-page="widget">
	<div class="cl-smart-advice__offer"><?php echo esc_html( 'SmartAdvice helps to solve important issues of your website. It includes performance and security features can be activated for WP sites easily.' ); ?></div>

	<?php if ( false === $compatible ) : ?>
		<p>
			<?php echo esc_html( 'Advice management requires php function "stream_socket_client".' ); ?><br>
		</p>
	<?php elseif ( empty( $advices_awp ) && empty( $advices_imunify ) ) : ?>
		<p>
			<?php echo esc_html( 'Advices not found.' ); ?><br>
		</p>
	<?php else : ?>

		<p><a href="<?php echo esc_attr( admin_url( 'options-general.php?page=' . CL_SMART_ADVICE_SLUG ) ); ?>"><?php echo esc_html( 'Learn more' ); ?></a></p>

		<?php if ( ! empty( $advices_awp ) ) : ?>
		<table class="cl-smart-advice__table cl-smart-advice__table_borderless">
			<tr>
				<th><?php echo esc_html( 'Performance Advice' ); ?></th>
				<th></th>
			</tr>
			<?php foreach ( $advices_awp as $advice ) : ?>
				<tr data-smart-advice="<?php echo esc_attr( $advice->uid() ); ?>" data-status="<?php echo esc_attr( $advice->status ); ?>">
					<td>
						<div class="cl-smart-advice__content">
							<div class="cl-smart-advice__description"><?php echo esc_html( $advice->description ); ?></div>
							<div data-for-status="pending">
								<div class="cl-smart-advice__progress">
									<div class="cl-smart-advice__spinner" data-smart-advice="spinner" data-percent="<?php echo esc_attr( $advice->spinnerPercent() ); ?>"></div>
									<div class="cl-smart-advice__percent">
										<span data-smart-advice="percent"><?php echo esc_attr( $advice->stagePercent() ); ?></span>%
									</div>
								</div>
							</div>
							<div data-for-status="review,applied">
								<div class="cl-smart-advice__status" data-smart-advice="status"><?php echo esc_html( $advice->status ); ?></div>
							</div>
						</div>
					</td>
					<td>
						<div class="cl-smart-advice__action">
							<a href="<?php echo esc_attr( admin_url( 'options-general.php?page=' . CL_SMART_ADVICE_SLUG ) ); ?>"><?php echo esc_html( 'See advice' ); ?></a>
						</div>
					</td>
				</tr>
			<?php endforeach; ?>
		</table>
		<?php endif; ?>

		<?php if ( ! empty( $advices_imunify ) ) : ?>
		<table class="cl-smart-advice__table cl-smart-advice__table_borderless">
			<tr>
				<th><?php echo esc_html( 'Security Advice' ); ?></th>
				<th></th>
			</tr>
			<?php foreach ( $advices_imunify as $advice ) : ?>
				<tr data-smart-advice="<?php echo esc_attr( $advice->uid() ); ?>" data-status="<?php echo esc_attr( $advice->status ); ?>">
					<td>
						<div class="cl-smart-advice__content">
							<div class="cl-smart-advice__description"><?php echo esc_html( $advice->description ); ?></div>
							<div data-for-status="pending">
								<div class="cl-smart-advice__progress">
									<div class="cl-smart-advice__spinner" data-smart-advice="spinner" data-percent="<?php echo esc_attr( $advice->spinnerPercent() ); ?>"></div>
									<div class="cl-smart-advice__percent">
										<span data-smart-advice="percent"><?php echo esc_attr( $advice->stagePercent() ); ?></span>%
									</div>
								</div>
							</div>
							<div data-for-status="review,applied">
								<div class="cl-smart-advice__status" data-smart-advice="status"><?php echo esc_html( $advice->status ); ?></div>
							</div>
						</div>
					</td>
					<td>
						<div class="cl-smart-advice__action">
							<a href="<?php echo esc_attr( admin_url( 'options-general.php?page=' . CL_SMART_ADVICE_SLUG ) ); ?>"><?php echo esc_html( 'See advice' ); ?></a>
						</div>
					</td>
				</tr>
			<?php endforeach; ?>
		</table>
		<?php endif; ?>
	<?php endif; ?>
</div>
