<?php
/**
 * Plugin name: CloudLinux SmartAdvice
 * Plugin URI: https://www.cloudlinux.com
 * Description: AccelerateWP helps to solve performance issues of your website. It includes Optimization Modules that can be activated for WP sites easily.
 * Version: 0.6-36
 * Requires at least: 5.0.0
 * Requires PHP: 5.6
 * Author: CloudLinux
 * Author URI: https://www.cloudlinux.com
 * Licence: CloudLinux Commercial License
 *
 * Copyright 2022 CloudLinux
 */

use CloudLinux\SmartAdvice\App\Plugin;
use CloudLinux\SmartAdvice\App\Cli\Commands;

if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( getenv( 'CL_SMART_ADVICE_DISABLED' ) ) {
	return;
}

// Remove old version of plugin.
if ( is_link( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
	// @phpcs:ignore WordPress.PHP.NoSilencedErrors.Discouraged
	@unlink( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) );

	return;
}

define( 'CL_SMART_ADVICE_SLUG', 'cl-smart-advice' );
define( 'CL_SMART_ADVICE_PATH', dirname( __FILE__ ) );
define( 'CL_SMART_ADVICE_VERSION', '0.6-36' );
define( 'CL_SMART_ADVICE_XRAY_RELEASE', '0.6-36.el7' );
define( 'CL_SMART_ADVICE_FOLDER_PATH', CL_SMART_ADVICE_PATH . '/cl-smart-advice' );
define( 'CL_SMART_ADVICE_FILE_PATH', __FILE__ );
define( 'CL_SMART_ADVICE_PLUGIN_URL', WPMU_PLUGIN_URL . '/cl-smart-advice' );

spl_autoload_register(
	function ( $class ) {
		$namespace = 'CloudLinux\\SmartAdvice\\';
		if ( preg_match( '#^' . preg_quote( $namespace, '/' ) . '#', $class ) ) {
			$path  = CL_SMART_ADVICE_FOLDER_PATH;
			$name  = str_replace( $namespace, '', $class );
			$file  = preg_replace( '#\\\\#', '/', $name ) . '.php';
			$path .= '/' . $file;

			// @phpcs:ignore WordPress.PHP.NoSilencedErrors.Discouraged
			if ( @file_exists( $path ) ) {
				include_once $path;
			}
		}
	}
);

try {
	if ( ! class_exists( Plugin::class ) ) {
		return;
	}

	if ( defined( 'WP_CLI' ) && WP_CLI ) {
		// @phpstan-ignore-next-line
		WP_CLI::add_command( 'smart-advice', Commands::class );
	}

	Plugin::instance()->init();
} catch ( \Exception $e ) {
	do_action( 'cl_smart_advice_set_error', E_WARNING, 'Init plugin failed: ' . $e->getMessage(), __FILE__, __LINE__ );
}
