<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App\Advice;

use CloudLinux\SmartAdvice\App\Model as BaseModel;

/**
 * Mail Send Date model
 */
class LogModel extends BaseModel {
	/**
	 * Advice ID.
	 *
	 * @var string
	 */
	public $id = '';

	/**
	 * Log type.
	 *
	 * @var string
	 */
	public $type = '';

	/**
	 * Created at.
	 *
	 * @var int
	 */
	public $created_at = 0;

	/**
	 * Get uid.
	 *
	 * @return string
	 */
	public function uid() {
		return $this->id;
	}

	/**
	 * Is valid model.
	 *
	 * @return bool
	 */
	public function isValid() {
		return ! empty( $this->id ) && ! empty( $this->type ) && ! empty( $this->created_at );
	}

	/**
	 * To array.
	 *
	 * @return array
	 */
	public function toArray() {
		return array(
			'id'         => $this->id,
			'type'       => $this->type,
			'created_at' => $this->created_at,
		);
	}
}
