<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App\Service;

/**
 * Mailer
 */
abstract class Mailer {
	/**
	 * Headers.
	 *
	 * @return string[]
	 */
	public function headers() {
		return array( 'Content-Type: text/html; charset=UTF-8' );
	}

	/**
	 * Subject.
	 *
	 * @param string $site_url Site URL.
	 *
	 * @return string
	 */
	abstract public function subject( $site_url );

	/**
	 * Template file.
	 *
	 * @return string
	 */
	abstract public function template();

	/**
	 * Allowed to send email.
	 *
	 * @return bool
	 */
	abstract public function allowed();

	/**
	 * Allows template data filtering for each email separately. Mail service populated the data with default attributes
	 * and merged with payload from mailer.
	 *
	 * @since 0.1-6 Added the $user_type parameter.
	 *
	 * @param  array  $data  Template data.
	 * @param  string $email  Email address.
	 * @param  string $user_type  User type.
	 * @param  string $email_type Email type.
	 *
	 * @return array
	 */
	public function filter_template_data( $data, $email, $user_type, $email_type ) {
		return $data;
	}

	/**
	 * Allows mailers to execute some actions after email was sent.
	 *
	 * @param  bool   $success  True if the email was sent successfully. False if there was an error.
	 * @param  string $user_type  Type of user.
	 * @param  string $email  Email.
	 * @param  string $subject  Letter subject.
	 * @param  string $body  Letter body.
	 * @param  array  $headers  Letter header.
	 *
	 * @return void
	 */
	public function post_email_sent( $success, $user_type, $email, $subject, $body, $headers ) {
		// Do nothing by default.
	}
}
