<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App\Service;

/**
 * Mail reminders
 */
class MailerReminders extends MailerAdvices {

	/**
	 * Links list to track with analytics. [event name -> parameter name].
	 *
	 * @var array
	 */
	protected $links_to_track = array(
		'reminder_link_clicked'        => 'panel_link',
		'reminder_cancel_link_clicked' => 'unsubscribe_link',
	);

	/**
	 * Analytics events aliases. [event name -> event alias].
	 *
	 * @var array
	 */
	protected $analytic_events = array(
		'email_opened' => 'reminder_opened',
		'email_sent'   => 'reminder_sent',
		'email_error'  => 'reminder_error',
	);
}
