<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App\Subscription;

use CloudLinux\SmartAdvice\App\Model as BaseModel;

/**
 * Subscription model.
 *
 * @since 0.1-6
 */
class Model extends BaseModel {
	/**
	 * Type or "all".
	 *
	 * @var string
	 */
	public $advice_type = '';

	/**
	 * Email address.
	 *
	 * @var string
	 */
	public $email = '';

	/**
	 * Token.
	 *
	 * @var string
	 */
	public $token = '';

	/**
	 * Creation time.
	 *
	 * @var int
	 */
	public $created_at = 0;

	/**
	 * Unsubscribed time.
	 *
	 * @var int
	 */
	public $unsubscribed_at = 0;

	/**
	 * Email type (advices, reminders).
	 *
	 * @var string
	 */
	public $email_type = '';

	/**
	 * Get uid.
	 *
	 * @return string
	 */
	public function uid() {
		return $this->token;
	}

	/**
	 * {@inheritDoc}
	 */
	public function isValid() {
		return ! empty( $this->email ) && ! empty( $this->advice_type ) && ! empty( $this->email_type );
	}

	/**
	 * {@inheritDoc}
	 */
	public function toArray() {
		return array(
			'advice_type'     => $this->advice_type,
			'email'           => $this->email,
			'token'           => $this->token,
			'created_at'      => $this->created_at,
			'unsubscribed_at' => $this->unsubscribed_at,
			'email_type'      => $this->email_type,
		);
	}

	/**
	 * Is Imunify subscription.
	 *
	 * @return bool
	 */
	public function is_imunify() {
		return false !== strpos( strtolower( $this->advice_type ), 'imunify' );
	}
}
