<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App;

/**
 * View interface
 */
abstract class View {
	/**
	 * Plugin action name.
	 *
	 * @return string
	 */
	protected function actionName() {
		return array_key_exists( 'action', $_GET ) ? sanitize_text_field( wp_unslash( $_GET['action'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended
	}

	/**
	 * Is plugin page
	 *
	 * @return bool
	 */
	protected function isPluginPage() {
		$page = array_key_exists( 'page', $_GET ) ? sanitize_text_field( wp_unslash( $_GET['page'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended

		return is_admin() && CL_SMART_ADVICE_SLUG === $page;
	}

	/**
	 * Render a template
	 *
	 * @param string $file template.
	 * @param array  $data payload.
	 *
	 * @return void
	 */
	public function render( $file, $data = array() ) {
		$path = CL_SMART_ADVICE_FOLDER_PATH . '/views/' . $file . '.php';
		if ( is_readable( $path ) ) {
			include $path;
		}
	}
}
