<?php
/**
 * Copyright (с) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2022 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * https://www.cloudlinux.com/legal/
 */

namespace CloudLinux\SmartAdvice\App\Views;

use CloudLinux\SmartAdvice\App\Advice\Manager;
use CloudLinux\SmartAdvice\App\View;

/**
 * Admin ui
 */
class Widget extends View {
	/**
	 * Advice manager.
	 *
	 * @var Manager
	 */
	private $manager;

	/**
	 * Constructor.
	 *
	 * @param Manager $manager advice.
	 */
	public function __construct( Manager $manager ) {
		$this->manager = $manager;

		if ( ! empty( $this->adviceManager()->advices() ) ) {
			add_action( 'wp_dashboard_setup', array( $this, 'add' ) );
		}
	}

	/**
	 * Advice manager.
	 *
	 * @return Manager
	 */
	public function adviceManager() {
		return $this->manager;
	}

	/**
	 * Add a new dashboard widget.
	 *
	 * @return void
	 */
	public function add() {
		if ( current_user_can( 'manage_options' ) ) {
			wp_add_dashboard_widget(
				'cl_smart_advice_widget',
				'SmartAdvice',
				array(
					$this,
					'view',
				),
				null,
				null,
				'normal',
				'high'
			);
		}
	}

	/**
	 * Output the contents of the dashboard widget.
	 */
	public function view() {
		$advices = $this->adviceManager()->advices();

		$advices_awp = array_filter(
			$advices,
			function ( $advice ) {
				return false === $advice->is_imunify();
			}
		);

		$advices_imunify = array_filter(
			$advices,
			function ( $advice ) {
				return true === $advice->is_imunify();
			}
		);

		$compatible = $this->adviceManager()->compatible();
		$this->render(
			'widget',
			array(
				'advices_awp'     => $advices_awp,
				'advices_imunify' => $advices_imunify,
				'compatible'      => $compatible,
			)
		);
	}
}

