<?php
/**
 * Subscription modal.
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}
?>
<div class="cl-smart-advice__modal" data-smart-advice-modal="subscription">
	<form class="cl-smart-advice__modal-form">
		<div class="cl-smart-advice__modal-form__title" data-smart-advice-modal-subscription="title">
			Upgrade your subscription
		</div>
		<div class="cl-smart-advice__modal-form__close" data-smart-advice-modal-close="subscription">
			<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" clip-rule="evenodd" d="M16 1.61143L14.3886 0L8 6.38857L1.61143 0L0 1.61143L6.38857 8L0 14.3886L1.61143 16L8 9.61143L14.3886 16L16 14.3886L9.61143 8L16 1.61143Z" fill="#AFAFAF"/>
			</svg>
		</div>
		<div class="cl-smart-advice__modal-imunify" data-smart-advice-modal-subscription="imunify">
			<div class="cl-smart-advice__modal-imunify__logo"><img src="<?php echo esc_attr( CL_SMART_ADVICE_PLUGIN_URL ); ?>/assets/images/imunify.logo.png" alt="Imunify"></div>
			<div class="cl-smart-advice__modal-imunify__title">Automatic Malware removal and ongoing protection</div>
			<ul class="cl-smart-advice__modal-imunify__list">
				<li>Immediately and automatically cleanup the malware recently detected on your site</li>
				<li>Real-time malware detection and cleanup</li>
				<li>Automatic zero-day threat blocking</li>
				<li>No manual intervention needed</li>
				<li>Proactive defense against evolving threats</li>
			</ul>
			<hr>
			<div class="cl-smart-advice__modal-imunify__subtitle">Benefits:</div>
			<ul class="cl-smart-advice__modal-imunify__list cl-smart-advice__modal-imunify__list_col">
				<li>Saves time and money</li>
				<li>Ensures uninterrupted service</li>
				<li>Prevents traffic loss</li>
				<li>Avoids legal issues</li>
				<li>Protects reputation</li>
				<li>Builds user trust</li>
				<li>Safeguards user data</li>
				<li>Prevents financial loss</li>
				<li>Maintains SEO rankings</li>
				<li>Enhances overall security</li>
			</ul>
			<div data-smart-advice-modal-subscription="note">Please contact your administrator to upgrade the subscription.</div>
			<a href="javascript:void(0)" data-smart-advice-modal-subscription="link" class="cl-smart-advice__modal-imunify__btn"><span>Buy now</span></a>
		</div>
		<div class="cl-smart-advice__modal-imunify" data-smart-advice-modal-subscription="other">
			<div class="cl-smart-advice__modal-form__subscription-status">
				To continue you need to have a subscription.<br>
				<span data-smart-advice-modal-subscription="note">Please contact your administrator to upgrade the subscription.</span>
			</div>
			<div class="cl-smart-advice__modal-form__footer">
				<a href="javascript:void(0)" data-smart-advice-modal-close="subscription" data-target="modal" class="cl-smart-advice__modal-form__btn cl-smart-advice__modal-form__btn_cancel">Close</a>
				<a href="javascript:void(0)" data-smart-advice-modal-subscription="link" class="cl-smart-advice__modal-form__btn cl-smart-advice__modal-form__btn_confirm">
					<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M2 18C1.45 18 0.979 17.8043 0.587 17.413C0.195667 17.021 0 16.55 0 16V2C0 1.45 0.195667 0.979 0.587 0.587C0.979 0.195667 1.45 0 2 0H9V2H2V16H16V9H18V16C18 16.55 17.8043 17.021 17.413 17.413C17.021 17.8043 16.55 18 16 18H2ZM6.7 12.7L5.3 11.3L14.6 2H11V0H18V7H16V3.4L6.7 12.7Z" fill="white"/>
					</svg>
					<span>Upgrade to apply</span>
				</a>
			</div>
		</div>
	</form>
</div>
