<?php
/**
 * Settings page.
 *
 * @var array $data settings.
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! is_array( $data ) ) {
	$data = array();
}

/**
 * Advices.
 *
 * @var \CloudLinux\SmartAdvice\App\Advice\Model[] $advices
 */
$advices_awp     = isset( $data['advices_awp'] ) ? $data['advices_awp'] : array();
$advices_imunify = isset( $data['advices_imunify'] ) ? $data['advices_imunify'] : array();
$compatible      = isset( $data['compatible'] ) ? $data['compatible'] : false;
?>

<div class="wrap cl-smart-advice" data-smart-advice-page="index">
	<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>

	<div class="cl-smart-advice__page">
		<?php require dirname( __FILE__ ) . '/modal.agreement.php'; ?>
		<?php require dirname( __FILE__ ) . '/modal.subscription.php'; ?>
		<?php require dirname( __FILE__ ) . '/modal.subscription.success.php'; ?>
		<?php require dirname( __FILE__ ) . '/modal.rollback.php'; ?>

		<?php if ( false === $compatible ) : ?>
		<p>
			<?php echo esc_html( 'Advice management requires php function "stream_socket_client".' ); ?><br>
		</p>
		<?php elseif ( empty( $advices_awp ) && empty( $advices_imunify ) ) : ?>
			<p>
				<?php echo esc_html( 'Advices not found' ); ?><br>
			</p>
		<?php else : ?>
			<div class="cl-smart-advice__offer">
				<?php echo esc_html( 'SmartAdvice helps to solve important issues of your website. It includes performance and security features can be activated for WP sites easily.' ); ?>
				<br>
			</div>

			<?php if ( ! empty( $advices_awp ) ) : ?>
			<table class="cl-smart-advice__table cl-smart-advice__table_borderless">
				<tr>
					<th><?php echo esc_html( 'Performance Advice' ); ?></th>
					<th><?php echo esc_html( 'Quick action' ); ?></th>
				</tr>
				<?php foreach ( $advices_awp as $advice ) : ?>
					<tr data-smart-advice="<?php echo esc_attr( $advice->uid() ); ?>" data-status="<?php echo esc_attr( $advice->statusUi() ); ?>" data-upgrade-button-text="<?php echo esc_attr( $advice->get_upgrade_to_apply_button_text() ); ?>">
						<td>
							<div class="cl-smart-advice__content">
								<div class="cl-smart-advice__description"><?php echo esc_html( $advice->description ); ?></div>
								<div data-for-status="pending">
									<div class="cl-smart-advice__progress">
										<div class="cl-smart-advice__spinner" data-smart-advice="spinner" data-percent="<?php echo esc_attr( $advice->spinnerPercent() ); ?>"></div>
										<div class="cl-smart-advice__percent">
											<span data-smart-advice="percent"><?php echo esc_attr( $advice->stagePercent() ); ?></span>%
										</div>
									</div>
								</div>
								<div data-for-status="review,applied">
									<div class="cl-smart-advice__status" data-smart-advice="status"><?php echo esc_html( $advice->status ); ?></div>
									<a href="javascript:void(0)" class="cl-smart-advice__tooltip">
										<?php echo esc_html( 'Details' ); ?>
										<span class="cl-smart-advice__tooltip_content">
											<?php echo esc_html( $advice->detailed_description ); ?>
											<?php if ( ! empty( $advice->note ) ) : ?>
												<div class="cl-smart-advice__tooltip_note">
													<strong>Note:</strong>
													<?php echo esc_html( $advice->note ); ?>
												</div>
											<?php endif; ?>
										</span>
									</a>
								</div>
							</div>
						</td>
						<td>
							<div class="cl-smart-advice__action">
								<div data-for-status="review">
									<a href="<?php echo esc_attr( admin_url( 'options-general.php?page=' . CL_SMART_ADVICE_SLUG ) ); ?>&action=apply&advice_uid=<?php echo esc_attr( $advice->uid() ); ?>" data-smart-advice-apply="<?php echo esc_attr( $advice->uid() ); ?>">
										<?php echo esc_html( $advice->get_apply_advice_button_text() ); ?>
									</a>
								</div>
								<div data-for-status="pending,outdated">
									&nbsp;
								</div>
								<div data-for-status="applied">
									<a href="<?php echo esc_attr( admin_url( 'options-general.php?page=' . CL_SMART_ADVICE_SLUG ) ); ?>&action=rollback&advice_uid=<?php echo esc_attr( $advice->uid() ); ?>" data-smart-advice-rollback="<?php echo esc_attr( $advice->uid() ); ?>">
										<?php echo esc_html( 'Rollback' ); ?>
									</a>
								</div>
							</div>
						</td>
					</tr>
				<?php endforeach; ?>
			</table>
			<?php endif; ?>

			<?php if ( ! empty( $advices_imunify ) ) : ?>
			<table class="cl-smart-advice__table cl-smart-advice__table_borderless">
				<tr>
					<th><?php echo esc_html( 'Security Advice' ); ?></th>
					<th><?php echo esc_html( 'Quick action' ); ?></th>
				</tr>
				<?php foreach ( $advices_imunify as $advice ) : ?>
					<tr data-smart-advice="<?php echo esc_attr( $advice->uid() ); ?>" data-status="<?php echo esc_attr( $advice->statusUi() ); ?>" data-upgrade-button-text="<?php echo esc_attr( $advice->get_upgrade_to_apply_button_text() ); ?>">
						<td>
							<div class="cl-smart-advice__content">
								<div class="cl-smart-advice__description"><?php echo esc_html( $advice->description ); ?></div>
								<div data-for-status="pending">
									<div class="cl-smart-advice__progress">
										<div class="cl-smart-advice__spinner" data-smart-advice="spinner" data-percent="<?php echo esc_attr( $advice->spinnerPercent() ); ?>"></div>
										<div class="cl-smart-advice__percent">
											<span data-smart-advice="percent"><?php echo esc_attr( $advice->stagePercent() ); ?></span>%
										</div>
									</div>
								</div>
								<div data-for-status="review,applied">
									<div class="cl-smart-advice__status" data-smart-advice="status"><?php echo esc_html( $advice->status ); ?></div>
									<a href="javascript:void(0)" class="cl-smart-advice__tooltip">
										<?php echo esc_html( 'Details' ); ?>
										<span class="cl-smart-advice__tooltip_content">
											<?php echo esc_html( $advice->detailed_description ); ?>
											<?php if ( ! empty( $advice->note ) ) : ?>
												<div class="cl-smart-advice__tooltip_note">
													<strong>Note:</strong>
													<?php echo esc_html( $advice->note ); ?>
												</div>
											<?php endif; ?>
										</span>
									</a>
								</div>
							</div>
						</td>
						<td>
							<div class="cl-smart-advice__action">
								<div data-for-status="review">
									<a href="<?php echo esc_attr( admin_url( 'options-general.php?page=' . CL_SMART_ADVICE_SLUG ) ); ?>&action=apply&advice_uid=<?php echo esc_attr( $advice->uid() ); ?>" data-smart-advice-apply="<?php echo esc_attr( $advice->uid() ); ?>">
										<?php echo esc_html( $advice->get_apply_advice_button_text() ); ?>
									</a>
								</div>
								<div data-for-status="pending,outdated">
									&nbsp;
								</div>
								<div data-for-status="applied">
									Applied
								</div>
							</div>
						</td>
					</tr>
				<?php endforeach; ?>
			</table>
			<?php endif; ?>
		<?php endif; ?>
	</div>
</div>

